function writeRVOB(basename,rvob)
% writeRVOB(basename,rvob)  --- writing river observation file
% Tijs Dekker 170707

fid=fopen([basename,'.rvob'],'wt');

%0.
fprintf(fid,'# MATLAB writeRVOB %s\r\n',datestr(now));
fprintf(    '# MATLAB writeRVOB %s\n'  ,datestr(now));

%1.
fprintf(fid,'%10g%10g%10g\r\n',rvob.NQRV, rvob.NQCRV, rvob.NQTRV);

%2.
fprintf(fid,'%10g%10g%10g\r\n',rvob.TOMULTRV,rvob.EVFRV,rvob.IOWTQRV);


for i=1:rvob.NQRV
    %3.
    fprintf(fid,'%10g%10g\r\n',rvob.NQOBRV(i),rvob.NQCLRV(i));
    %4.
    fprintf(fid,'%11s%10g%10g%10g%10g%10g%10g\r\n',...
    rvob.OBSNAM{i},rvob.IREFSP{i},rvob.TOFFSET(i),rvob.HOBS(i),rvob.STATISTIC(i),rvob.STATFLAG(i),rvob.PLOTSYMBOL(i));

    %5
    for iC=1:rvob.NQCLRV(i)
        fprintf(fid,'%10g%10g%10g%10g\r\n',rvob.Layer{i}(iC),rvob.Row{i}(iC),rvob.Column{i}(iC),rvob.Factor{i}(iC));
    end

    if rvob.IOWTQRV>0
        %6
        fprintf(fid,'%10g%10g\r\n',rvob.FMTIN(i),rvob.IPRN);
        %7
        warray(rvob.WTQ)        
    end
end
fclose(fid);
